// 3D PrinterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "3D Printer.h"
#include "3D PrinterDlg.h"

#include "typedef.h"
#include "Delay.h"
#include "Command.h"
#include <math.h>

#include <setupapi.h>
#include <devguid.h>
#include <initguid.h>
#include "usbprint.h"
#include "uart.h"
#include <dbt.h>

#pragma comment(lib,"setupapi.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static BOOL IsExit=FALSE;
volatile BOOL bDeviceChange=FALSE;

//DEFINE_GUID(GUID_DEVINTERFACE_USBCOM,0xa5dcbf10,0x6530,0x11d2,0x90,0x1f,0x00,0xc0,0x4f,0xb9,0x51,0xed);
//DEFINE_GUID(GUID_DEVINTERFACE_USBCOMPOSITE, 0xa5dcbf10,0x6530,0x11d2,0x90,0x1f,0x00,0xc0,0x4f,0xb9,0x51,0xed);
//DEFINE_GUID(GUID_DEVINTERFACE_USBPRINT, 0x28d78fad, 0x5a12, 0x11D1, 0xae, 0x5b, 0x00, 0x00, 0xf8, 0x03, 0xa8, 0xc2);
EXTERN_C const GUID GUID_DEVINTERFACE_USBPRINT;
static CMy3DPrinterDlg* pDlg=NULL;
volatile   BOOL UsbConnect=FALSE;
double Hour=0;

#define MAIN_DIALOG_TITLE1 "3D Printer SDK V3.4.1"
extern void ispMagic(unsigned char *Magic);

BOOL UartError=FALSE;
volatile BOOL UartConnect=FALSE;
UCHAR UART_Port=0xff;
UCHAR u_Serial[255]={0};
unsigned long BaudRate[]={115200};
//HANDLE hDeviceThread=NULL;//߳̾
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy3DPrinterDlg dialog

CMy3DPrinterDlg::CMy3DPrinterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy3DPrinterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy3DPrinterDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy3DPrinterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy3DPrinterDlg)
	DDX_Control(pDX, IDC_TAB1, m_tab);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy3DPrinterDlg, CDialog)
	//{{AFX_MSG_MAP(CMy3DPrinterDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_WM_CLOSE()
	ON_WM_SETCURSOR()
	ON_WM_DEVICECHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CString ReadIniString(CString Section,CString Key)
{
	CString  inipath;
    CString  Value;
	Value="";
	GetModuleFileName(NULL,inipath.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
    inipath.ReleaseBuffer(); 
    int pos = inipath.ReverseFind('\\'); 
    inipath = inipath.Left(pos);
	inipath = inipath + "\\Config.ini";
	GetPrivateProfileString((LPCTSTR)Section,(LPCTSTR)Key,(LPCTSTR)Value,Value.GetBuffer(MAX_PATH),MAX_PATH,(LPCTSTR)inipath);
	return Value;
}

void WriteIniString(CString Section,CString Key,CString Value)
{
	CString  inipath;
	GetModuleFileName(NULL,inipath.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
    inipath.ReleaseBuffer(); 
    int pos = inipath.ReverseFind('\\'); 
    inipath = inipath.Left(pos);
	inipath = inipath + "\\Config.ini";
	WritePrivateProfileString((LPCTSTR)Section,(LPCTSTR)Key,(LPCTSTR)Value,(LPCTSTR)inipath);
}

typedef struct tagKeyAndValue{
	CString Key;
	CString Value;
}KeyAndValue;

int GetKeyAndValue(CString Section,KeyAndValue* pKeyAndValue)
{
	CString strtemp;
	int posit,i;
	i=0;
	CString  inipath;
	char KeyAndValueBuffer[10*MAX_PATH];
	char *str=KeyAndValueBuffer;
	
	GetModuleFileName(NULL,inipath.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
    inipath.ReleaseBuffer(); 
    int pos = inipath.ReverseFind('\\'); 
    inipath = inipath.Left(pos);
	inipath = inipath + "\\Config.ini";
	GetPrivateProfileSection((LPCTSTR)Section,KeyAndValueBuffer,MAX_PATH,(LPCTSTR)inipath);
	
	while(*str!=0) //strΪlpReturnedStringصַ
	{        
		strtemp = str;
		posit=strtemp.Find('=',0);
		pKeyAndValue[i].Key=strtemp.Left(posit);
		pKeyAndValue[i].Value=strtemp.Right(strtemp.GetLength()-posit-1);
		i++;
		str += strtemp.GetLength()+1;
	}
	return i;
}
//-------------------------------------------------------------------------------------
unsigned char CheckDevice(void) 
{
	unsigned char Magic[3];
	if(UartConnect==TRUE)
		return 1;
	if(UsbConnect==FALSE)
		return 0;
	
	ispMagic(Magic);
	if(Magic[0]=='A' && Magic[1]=='P' && Magic[2]=='P')
		return 1;
	else
		return 2;
}
/*
unsigned char CheckUSB(void) 
{
	unsigned char Magic[3];
	if(UsbConnect==FALSE)
		return 0;
	
	ispMagic(Magic);
	if(Magic[0]=='A' && Magic[1]=='P' && Magic[2]=='P')
		return 1;
	else
		return 2;
}
*/

UCHAR EnumSerialEx(U8 *m_Port)
{
	HKEY hKey;
	//CString str;
	LPCTSTR data_Set = "HARDWARE\\DEVICEMAP\\SERIALCOMM\\";
	long ret0 = RegOpenKeyEx(HKEY_LOCAL_MACHINE, data_Set, 0, KEY_READ, &hKey);
	if (ret0 != ERROR_SUCCESS)
	{
		return 0;
	}
	int i = 1;				//put the port index from 1;
	CHAR Name[50];
	UCHAR szPortName[50];
	LONG Status;
	DWORD dwIndex = 0;
	DWORD dwName;
	DWORD dwSizeofPortName;
	DWORD Type;
	dwName = sizeof(Name);
	dwSizeofPortName = sizeof(szPortName);
	do
	{
		Status = RegEnumValue(hKey, dwIndex++, Name, &dwName, NULL, &Type,
			szPortName, &dwSizeofPortName);
		if ((Status == ERROR_SUCCESS) || (Status == ERROR_MORE_DATA))
		{
			//str = CString(szPortName).Mid(3);;       // ַ
			//m_Port[i] = atoi((const char *)str);
			m_Port[i] = atoi((const char *)&szPortName[3]);
			i++;// ڼ
		}
		dwName = sizeof(Name);
		dwSizeofPortName = sizeof(szPortName);
	} while ((Status == ERROR_SUCCESS) || (Status == ERROR_MORE_DATA));
	RegCloseKey(hKey);
	if(i==1)//ûҵ
		i=0;
	return i;
}

DWORD WINAPI UartCheck_Thread(LPVOID pParam)
{
	//---------------------------
	U32 UseTime;
	CString StrHour;
	//---------------------------
	unsigned char ID[8];
	//unsigned char Status;
	U16 u16Value=0;
	BOOLEAN bAuto=0;
	U8 Value=0;
	CString StrVal;
	CString StrTxt;
	unsigned char usb_Serial[255],Index;
	BYTE i=0;
	unsigned char SerialPortNum=0;
	unsigned char j;
	CMy3DPrinterApp* pApp;
	pApp=(CMy3DPrinterApp*)AfxGetApp();
	CMy3DPrinterDlg* pDlg=(CMy3DPrinterDlg*)pApp->m_pMainWnd;
	HWND hwndStatusBar=pDlg->m_StatusBar.GetSafeHwnd();
	//HWND hwndCheckButton;
	HWND hwndSlider;
	HWND hwndLedCurrent;
	HWND hwndLedIndex;
	CString StrLedDefaultStatus;
	//pDlg->m_para5.GetDlgItem(IDC_CHECK_LED_DEFAULT,&hwndCheckButton);
	pDlg->m_para1.GetDlgItem(IDC_SLIDER_LED,&hwndSlider);
	pDlg->m_para1.GetDlgItem(IDC_EDIT_LED,&hwndLedCurrent);
	pDlg->m_para1.GetDlgItem(IDC_LED_INDEX,&hwndLedIndex);
	
	while(1)
	{
		if(IsExit)
		{
			CloseUart(u_Serial[UART_Port]);
			break;
		}
		//Delay1Ms(50);
		Sleep(50);
//-----------------------------------------
		if(pDlg->m_para5.IspWorking)
		{
			CloseUart(u_Serial[UART_Port]);
			UartConnect=FALSE;
			UartError=FALSE;
			//continue;
			//SuspendThread(hDeviceThread);
			break;
		}
//-----------------------------------------
		if(UsbConnect)
		{
			UsbConnect=ShakeHands(0,0);
			if(UsbConnect==FALSE)
			{
				StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
				SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
				StrTxt="SN: XX-XX-XX-XX-XX-XX";
				SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
			}
			continue;
		}
		if(UartError)
		{
			CloseUart(u_Serial[UART_Port]);
			UartConnect=FALSE;
			UartError=FALSE;
			continue;
		}
		
		SerialPortNum=EnumSerialEx(usb_Serial);
		if(SerialPortNum==0)
		{
			if(UartConnect)
			{
				CloseUart(u_Serial[UART_Port]);
			}
			
			UartConnect=FALSE;
			UartError=FALSE;
			UsbConnect=ShakeHands(0,0);
			if(UsbConnect==FALSE)
			{
				StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
				SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
				StrTxt="SN: XX-XX-XX-XX-XX-XX";
		        SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
			}
			else
				goto LableConnect;
			continue;
		}
		
		if(UartConnect)
			continue;
		
		SerialPortNum=EnumSerialEx(u_Serial);
		
		UART_Port=0xff;
		if(SerialPortNum==0)
		{
			UartConnect=FALSE;
			UsbConnect=ShakeHands(0,0);
			if(UsbConnect)
				goto LableConnect;
			continue;
		}
		
		for (i=0; i<SerialPortNum; i++)
		{
			for(j=0;j<COUNTOF(BaudRate);j++)
			{
				if(ShakeHands(u_Serial[i],BaudRate[j])==TRUE)
				{
					UART_Port=i;
					UartConnect=TRUE;
					//StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
					//SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
					break;
				}
				CloseUart(u_Serial[i]);
			}
			if(UartConnect)
				break;
		}
		if(UartConnect)
			goto LableConnect;
		UsbConnect=ShakeHands(0,0);
		if(UsbConnect==FALSE)
			continue;
		//---------------------------------------------
LableConnect:
		StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
		SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		if(CheckDevice()==1)
		{
			if(GetLedDefaultStatus(&Value))
			{
				if(Value)
				{
					StrLedDefaultStatus=_CS("Led.Off");
					::CheckRadioButton(pDlg->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_OFF);
				}
				else
				{
					StrLedDefaultStatus=_CS("Led.On");
					::CheckRadioButton(pDlg->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_ON);
				}
				::SetDlgItemText(pDlg->m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
			}
			
			GetProductID(ID);
			StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
			SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
			//----------------------------------
			Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
	        //Index = pDlg->m_para1.m_LedIndex.GetCurSel();
			if(GetCurrent(Index,&Value))
			{	
				if(Value<=100)
				{
				StrVal.Format("%d",Value);
				SendMessage(hwndSlider, TBM_SETPOS, TRUE, Value);
				//m_para1.SliderPos=Value;
				SetDlgItemText(pDlg->m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
				}
			}
			//-----------------------------------
			if(GetUseTime(&UseTime))
			{
				Hour=UseTime/(3600.0f);
				StrHour.Format("%.1f",Hour);
				SetDlgItemText(pDlg->m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
			}
			/*
			if(GetUvPower(&u16Value))
			{
				pDlg->m_para4.m_UvPower=u16Value;
				StrVal.Format("%d",u16Value);
				::SetDlgItemText(pDlg->m_para4.GetSafeHwnd(),IDC_UV_POWER,StrVal);
			}
			if(GetUvAuto(&bAuto))
			{
				if(bAuto)
					::CheckRadioButton(pDlg->m_para4.GetSafeHwnd(),IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_ON);
				else
					::CheckRadioButton(pDlg->m_para4.GetSafeHwnd(),IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
			}
			*/
		}
		//----------------------------------
	}
	
	return 1;
}

/////////////////////////////////////////////////////////////////////////////
// CMy3DPrinterDlg message handlers


BOOL CMy3DPrinterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	pDlg=this;
	_CWndCS(this);
	//unsigned char Status;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    DEV_BROADCAST_DEVICEINTERFACE DevInt;
	memset(&DevInt,0,sizeof(DEV_BROADCAST_DEVICEINTERFACE));
	DevInt.dbcc_size = sizeof(DEV_BROADCAST_DEVICEINTERFACE);
	DevInt.dbcc_devicetype = DBT_DEVTYP_DEVICEINTERFACE;
	DevInt.dbcc_classguid=GUID_DEVINTERFACE_USBPRINT;
    HDEVNOTIFY hDevNotify=RegisterDeviceNotification(this->GetSafeHwnd(),&DevInt,DEVICE_NOTIFY_WINDOW_HANDLE);
	/*
	static UINT indicators[] =
	{
	ID_SEPARATOR,                   // status line indicator
	ID_INDICATOR_CAPS,              //CAP lock indicator.
	ID_INDICATOR_NUM,               //NUM lock indicator.
	ID_INDICATOR_SCRL,              //SCRL lock indicator.
	};
	

	if(!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators, sizeof(indicators) / sizeof(UINT))){
		TRACE0("Failed to create status bar\n");
		return -1;
	}

	UINT nID;        //״̬ķ
	m_wndStatusBar.SetPaneInfo(0,nID,SBPS_STRETCH|SBPS_NOBORDERS,100);               //ֵnID
	m_wndStatusBar.SetPaneText(0,"");
	
	m_wndStatusBar.SetPaneInfo(1,nID,SBPS_NORMAL,100);
	m_wndStatusBar.SetPaneText(1,"д");
	
	m_wndStatusBar.SetPaneInfo(2,nID,SBPS_POPOUT,100);
    m_wndStatusBar.SetPaneText(2,"");
	*/
    
	m_StatusBar.Create(WS_CHILD|WS_VISIBLE|SBT_OWNERDRAW, CRect(0,0,0,0), this, 0); 
	//int strPartDim[2]= {100,-1}; //ָ
	int strPartDim[2]= {120,-1}; //ָ
	m_StatusBar.SetParts(2, strPartDim);
	
	//״̬ı
	m_StatusBar.SetText(_CS("WarningGeneral.DeviceDisconnect"), 0, 0);
	m_StatusBar.SetText("SN: XX-XX-XX-XX-XX-XX", 1, 0);
	//״̬мͼ
	//m_StatusBar.SetIcon(1, 
	//	SetIcon(AfxGetApp()->LoadIcon(IDR_MAINFRAME),
    //                            FALSE));//Ϊڶмӵͼ
	
    m_para5.IspWorking=FALSE;

	CRect rc,rect,Rect,ScreenRect;
	KeyAndValue   s_KeyAndValue[255];
	int DlgCnt,i,j=0;
    CString DlgName[4];//ʾ4ѡ

	DlgName[0]=_CS("Tab.Led");//"LED";
	DlgName[1]=_CS("Tab.Flip");//"ͼ";
	DlgName[2]=_CS("Tab.System");//"ϵͳ";
    //DlgName[3]= "UV";//UVѡ


	DlgCnt=GetKeyAndValue("dialog",s_KeyAndValue);

	//IDC_TAB1Ϊ
	m_para1.Create(IDD_DIALOG1,GetDlgItem(IDC_TAB1));
	m_para5.Create(IDD_DIALOG5,GetDlgItem(IDC_TAB1));
	m_para6.Create(IDD_DIALOG6,GetDlgItem(IDC_TAB1));
	//m_para4.Create(IDD_DIALOG4,GetDlgItem(IDC_TAB1));//UVѡ

	//ѡ
	for(i=0;i<DlgCnt;i++)
	{
		if(s_KeyAndValue[i].Key=="dlg1" && s_KeyAndValue[i].Value=="true")
		{
			pDialog[j] = &m_para1;
			m_tab.InsertItem(j,DlgName[0]);
		}
		else if(s_KeyAndValue[i].Key=="dlg2" && s_KeyAndValue[i].Value=="true")
		{
			pDialog[j] = &m_para6;
			m_tab.InsertItem(j,DlgName[1]);
		}		
		else if(s_KeyAndValue[i].Key=="dlg3" && s_KeyAndValue[i].Value=="true")
		{
			pDialog[j] = &m_para5;
			m_tab.InsertItem(j,DlgName[2]);
		}
		else if(s_KeyAndValue[i].Key=="dlg4" && s_KeyAndValue[i].Value=="true")
		{
			//pDialog[j] = &m_para4;//UVѡ
			//m_tab.InsertItem(j,DlgName[3]);//UVѡ
		}
		else
			continue;
		j++;
	}

	if(m_tab.GetItemCount()<=0)
	{
		m_tab.InsertItem(0,DlgName[0]);
		m_tab.InsertItem(1,DlgName[1]);
		m_tab.InsertItem(2,DlgName[2]);
		//m_tab.InsertItem(3,DlgName[3]);//UVѡ
		
		//ѶԻָ뱣
		pDialog[0] = &m_para1;
		pDialog[1] = &m_para6;
		pDialog[2] = &m_para5;
		//pDialog[3] = &m_para4;//UVѡ
	}

	CString String;
	 GetWindowText(String);

	//浱ǰѡ
	String=MAIN_DIALOG_TITLE1;
	SetWindowText(String);
    m_CurSelTab = 0;

//---------------------------------------------
	 //m_CurSelTab = m_tab.GetCurSel();
	 pDialog[m_CurSelTab]->GetClientRect(&rc);
	 
	 GetWindowRect(&ScreenRect);
	 
	 rc.top += 25;
	 rc.left +=8;
	 rc.bottom +=25;
	 rc.right +=8;
	 m_tab.GetClientRect(&rect);
	 
	 //rect.top +=5;
	 rect.bottom=rect.top+rc.bottom+8;
	 rect.right=rect.left+rc.right+8;
	 
	 pDialog[m_CurSelTab]->MoveWindow(&rc);
	 m_tab.MoveWindow(&rect);
	 
	 GetClientRect(&Rect);
	 
	 Rect.left=ScreenRect.left;
	 Rect.top=ScreenRect.top;
	 
	 Rect.bottom=Rect.top+rect.bottom+51;//Rect.bottom=Rect.top+rect.bottom+35;
	 Rect.right=Rect.left+rect.right+8;
	 
	MoveWindow(&Rect);
	//RepositionBars(AFX_IDW_CONTROLBAR_FIRST,AFX_IDW_CONTROLBAR_LAST,0);
	m_StatusBar.MoveWindow(0,Rect.bottom,Rect.right,20,FALSE);
//------------------------------------------
	//Ĭϵѡ
     m_tab.SetCurSel(m_CurSelTab);

	 for(i=0;i<m_tab.GetItemCount();i++)
		pDialog[i]->ShowWindow(SW_HIDE);
     //ʾʼҳ
	 pDialog[0]->ShowWindow(SW_SHOW);
//-------------------------------------------
	 U32 UseTime=0;
	CString StrHour;
	 U8 Value=0;
	 U16 u16Value=0;
	 BOOLEAN bAuto=0;
	 CString StrVal;
	 unsigned char ID[8];
	 CString StrTxt;
	 CString StrLedDefaultStatus;
	 CString DevIndex;
	 //unsigned char flag=OpenUsbDevice();
	 unsigned char flag=ShakeHands(0,0);
	 m_para4.CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
	 m_para5.CheckRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_OFF);
	 if(flag)
	 {
		 UsbConnect=TRUE;
		 m_StatusBar.SetText(_CS("WarningGeneral.DeviceConnect"), 0, 0);
		 memset(DeviceName,0,MAX_PATH);
		 strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
		 if(CheckDevice()==1)
		 {
			 if(GetLedDefaultStatus(&Value))
			 {
				 if(Value)
				 {
					 StrLedDefaultStatus=_CS("Led.Off");
					 m_para5.CheckRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_OFF);
				 }
				 else
				 {
					 StrLedDefaultStatus=_CS("Led.On");
					 m_para5.CheckRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_ON);
				 }
				::SetDlgItemText(m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
			}
			GetProductID(ID);
			StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
			m_StatusBar.SetText(StrTxt, 1, 0);
			if(GetCurrent(0,&Value))
			{	
				if(Value<=100)
				{
				StrVal.Format("%d",Value);
				m_para1.m_Slider_Led.SetPos(Value);
				m_para1.SliderPos=Value;
				::SetDlgItemText(m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
				}
			}
			if(GetUseTime(&UseTime))
			{
				Hour=UseTime/(3600.0f);
				StrHour.Format("%.1f",Hour);
				::SetDlgItemText(m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
			}
			/*
			if(GetUvPower(&u16Value))
			{
				m_para4.m_UvPower=u16Value;
				StrVal.Format("%d",u16Value);
				::SetDlgItemText(m_para4.GetSafeHwnd(),IDC_UV_POWER,StrVal);
			}
			if(GetUvAuto(&bAuto))
			{
				if(bAuto)
					m_para4.CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_ON);
				else
					m_para4.CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
			}
			*/
		 }
	 }
	 		 //--------------------------------------------------------------
	 m_para1.m_DeviceIndex.ResetContent();
	 m_para1.m_DeviceIndex.SetCurSel(-1);
	 for(i=0;i<USBDeviceInfo.count;i++)
	 {
		 DevIndex.Format(" %d ",i+1);
		 m_para1.m_DeviceIndex.AddString(DevIndex);
	 }
	 if(USBDeviceInfo.count==0)
		 m_para1.m_DeviceIndex.AddString(" XXX ");
	 m_para1.m_DeviceIndex.SetCurSel(0);
	 //-------------------------
	 m_para5.m_DeviceIndex.ResetContent();
	 m_para5.m_DeviceIndex.SetCurSel(-1);
	 for(i=0;i<USBDeviceInfo.count;i++)
	 {
		 DevIndex.Format(" %d ",i+1);
		 m_para5.m_DeviceIndex.AddString(DevIndex);
	 }
	 if(USBDeviceInfo.count==0)
		 m_para5.m_DeviceIndex.AddString(" XXX ");
	 m_para5.m_DeviceIndex.SetCurSel(0);
	 //--------------------------
	 m_para6.m_DeviceIndex.ResetContent();
	 m_para6.m_DeviceIndex.SetCurSel(-1);
	 for(i=0;i<USBDeviceInfo.count;i++)
	 {
		 DevIndex.Format(" %d ",i+1);
		 m_para6.m_DeviceIndex.AddString(DevIndex);
	 }
	 if(USBDeviceInfo.count==0)
		 m_para6.m_DeviceIndex.AddString(" XXX ");
	 m_para6.m_DeviceIndex.SetCurSel(0);
		//--------------------------------------------------------------
	 m_para4.m_DeviceIndex.ResetContent();
	 m_para4.m_DeviceIndex.SetCurSel(-1);
	 for(i=0;i<USBDeviceInfo.count;i++)
	 {
		 DevIndex.Format(" %d ",i+1);
		 m_para4.m_DeviceIndex.AddString(DevIndex);
	 }
	 if(USBDeviceInfo.count==0)
		 m_para4.m_DeviceIndex.AddString(" XXX ");
	 m_para4.m_DeviceIndex.SetCurSel(0);
//--------------------------------------------
	 
	//hDeviceThread=CreateThread(NULL,0,UartCheck_Thread,NULL,0,NULL);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMy3DPrinterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy3DPrinterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy3DPrinterDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy3DPrinterDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	CRect rc,rect,Rect,ScreenRect;
	pDialog[m_CurSelTab]->ShowWindow(SW_HIDE);
	m_CurSelTab = m_tab.GetCurSel();
	pDialog[m_CurSelTab]->GetClientRect(&rc);

	GetWindowRect(&ScreenRect);

	rc.top += 25;
	rc.left +=8;
	rc.bottom +=25;
	rc.right +=8;
	m_tab.GetClientRect(&rect);

	//rect.top +=5;
	rect.bottom=rect.top+rc.bottom+8;
	rect.right=rect.left+rc.right+8;

    pDialog[m_CurSelTab]->MoveWindow(&rc);
	m_tab.MoveWindow(&rect);

	GetClientRect(&Rect);

	Rect.left=ScreenRect.left;
	Rect.top=ScreenRect.top;

	Rect.bottom=Rect.top+rect.bottom+51;//Rect.bottom=Rect.top+rect.bottom+35;
	Rect.right=Rect.left+rect.right+8;

	MoveWindow(&Rect);
	
	//RepositionBars(AFX_IDW_CONTROLBAR_FIRST,AFX_IDW_CONTROLBAR_LAST,0);
	m_StatusBar.MoveWindow(0,Rect.bottom,Rect.right,20,FALSE);
	
    pDialog[m_CurSelTab]->ShowWindow(SW_SHOW);
	pDialog[m_CurSelTab]->OnInitDialog();
    if(m_CurSelTab==1)
		MessageBox(_CS("FLIP.HdmiInWarn"),_CS("WarningUart.Title"),MB_OK);
	
	*pResult = 0;
}


void CMy3DPrinterDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	//if(pThread!=NULL)
	//{
	//	IsExit=TRUE;
	//}
	//else 
	{
		CDialog::OnClose();
	}
}

void CMy3DPrinterDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	IsExit=TRUE;
	Delay1Ms(200);
	CDialog::OnCancel();
}

BOOL CMy3DPrinterDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class

	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
	{
		return TRUE; 
	}
	if(pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN) 
		return TRUE;
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CMy3DPrinterDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// TODO: Add your message handler code here and/or call default
	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

BOOL CMy3DPrinterDlg::OnDeviceChange(UINT nEventType,DWORD dwData)
{
	U32 UseTime,i;
	CString StrHour;
	CString StrLedDefaultStatus;
	//unsigned char Status;
	U8 Value=0,Index;
	U16 u16Value=0;
	BOOLEAN bAuto=0;
	CString StrVal;
	//unsigned char flag;
	unsigned char ID[8];
	CString StrTxt,DevIndex;
	DEV_BROADCAST_DEVICEINTERFACE* dbd = (DEV_BROADCAST_DEVICEINTERFACE*) dwData;
	HWND hwndStatusBar=m_StatusBar.GetSafeHwnd();
	HWND hwndLedIndex=m_para1.m_LedIndex.GetSafeHwnd();
	if(dbd==NULL)
		return TRUE;
	//Ϣƥ,guid
	if(dbd->dbcc_classguid!=GUID_DEVINTERFACE_USBPRINT)
		return TRUE;
	//if(m_para5.IspWorking)
	//	return TRUE;
	if(CheckUsbVidPid(dbd->dbcc_name,USB_VID,USB_PID)==FALSE)
		return TRUE;
	//if(CheckUsbSerialNo(dbd->dbcc_name,USB_DEV_SERIAL_NO)==FALSE)
	//	return TRUE;
	//flag=EnumUsbDevice();
	//Ը¼д.
	switch (nEventType)
	{
	case DBT_DEVICEREMOVECOMPLETE://ƳUSB
	case DBT_DEVICEARRIVAL://USB
		if(m_para5.IspWorking)
			break;
		if(UartConnect)
			break;
		bDeviceChange=TRUE;
		if(ShakeHands(0,0)==FALSE)
		{
			StrTxt=" " + _CS("WarningGeneral.DeviceDisconnect");
			::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
			StrTxt="SN: XX-XX-XX-XX-XX-XX";
			::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
			UsbConnect=FALSE;
		}
		//--------------------------------------------------------------
		m_para1.m_DeviceIndex.ResetContent();
		m_para1.m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i+1);
			m_para1.m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_para1.m_DeviceIndex.AddString(" XXX ");
		m_para1.m_DeviceIndex.SetCurSel(0);
		//-------------------------
		m_para5.m_DeviceIndex.ResetContent();
		m_para5.m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i+1);
			m_para5.m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_para5.m_DeviceIndex.AddString(" XXX ");
		m_para5.m_DeviceIndex.SetCurSel(0);
		//--------------------------
		m_para6.m_DeviceIndex.ResetContent();
		m_para6.m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i+1);
			m_para6.m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_para6.m_DeviceIndex.AddString(" XXX ");
		m_para6.m_DeviceIndex.SetCurSel(0);
		//--------------------------------------------------------------
		m_para4.m_DeviceIndex.ResetContent();
		m_para4.m_DeviceIndex.SetCurSel(-1);
		for(i=0;i<USBDeviceInfo.count;i++)
		{
			DevIndex.Format(" %d ",i+1);
			m_para4.m_DeviceIndex.AddString(DevIndex);
		}
		if(USBDeviceInfo.count==0)
			m_para4.m_DeviceIndex.AddString(" XXX ");
		m_para4.m_DeviceIndex.SetCurSel(0);
		//--------------------------------------------------------------
		USBDevIndex=0;
		if(USBDeviceInfo.count==0)
			break;

		StrTxt=" " + _CS("WarningGeneral.DeviceConnect");
		::SendMessage(hwndStatusBar, SB_SETTEXT,0, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		UsbConnect=TRUE;
		//if(strcmp(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0])==0)
		//	break;
		memset(DeviceName,0,MAX_PATH);
		strcpy(DeviceName,&USBDeviceInfo.DeviceName[USBDevIndex][0]);
		if(CheckDevice()==1)
		{
			if(GetLedDefaultStatus(&Value))
			{
				if(Value)
				{
					StrLedDefaultStatus=_CS("Led.Off");
					m_para5.CheckRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_OFF);
				}
				else
				{
					StrLedDefaultStatus=_CS("Led.On");
					m_para5.CheckRadioButton(IDC_LED_DEFAULT_ON,IDC_LED_DEFAULT_OFF,IDC_LED_DEFAULT_ON);
				}
				::SetDlgItemText(m_para5.GetSafeHwnd(),IDC_LED_DEFAULT_STATUS,StrLedDefaultStatus);
			}
			GetProductID(ID);
			StrTxt.Format("SN: %02X-%02X-%02X-%02X-%02X-%02X",ID[0],ID[1],ID[2],ID[3],ID[4],ID[5]);
			::SendMessage(hwndStatusBar, SB_SETTEXT,1, (LPARAM)StrTxt.GetBuffer(StrTxt.GetLength()));
		//----------------------------------
			Index=(int)::SendMessage(hwndLedIndex, CB_GETCURSEL, 0, 0);
			//Index=m_para1.m_LedIndex.GetCurSel();
			if(GetCurrent(Index,&Value)==FALSE)
				break;	
			if(Value>100)
				break;
			StrVal.Format("%d",Value);
			m_para1.m_Slider_Led.SetPos(Value);
			m_para1.SliderPos=Value;
			::SetDlgItemText(m_para1.GetSafeHwnd(),IDC_EDIT_LED,StrVal);
			if(GetUseTime(&UseTime))
			{
				Hour=UseTime/(3600.0f);
				StrHour.Format("%.1f",Hour);
				::SetDlgItemText(m_para5.GetSafeHwnd(),IDC_USE_HOUR,StrHour);
			}
			/*
			if(GetUvPower(&u16Value))
			{
				m_para4.m_UvPower=u16Value;
				StrVal.Format("%d",u16Value);
				::SetDlgItemText(m_para4.GetSafeHwnd(),IDC_UV_POWER,StrVal);
			}
			if(GetUvAuto(&bAuto))
			{
				if(bAuto)
					m_para4.CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_ON);
				else
					m_para4.CheckRadioButton(IDC_UV_AUTO_ON,IDC_UV_AUTO_OFF,IDC_UV_AUTO_OFF);
			}
			*/
		}
		//----------------------------------
		break;
	default:
		break;
	}
	bDeviceChange=FALSE;
	return TRUE;
}
